/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.SGRegistry;
import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.blocks.GelPortalBlock;
import com.legacy.structure_gel.util.Internal;
import com.legacy.structure_gel.util.capability.GelEntity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.ConfirmBackupScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Internal
public class SGClientEvents {
    protected static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(SGClientEvents::clientInit);
        forgeBus.addListener(SGClientEvents::skipExperimentalBackupScreen);
        forgeBus.addListener(SGClientEvents::onPlaySound);
    }

    protected static void clientInit(FMLClientSetupEvent event) {
        SGRegistry.GelBlocks.BLOCKS.forEach(b -> RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228645_f_()));
    }

    protected static void skipExperimentalBackupScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (StructureGelConfig.CLIENT.skipExperimentalScreen()) {
            ConfirmScreen gui;
            if (event.getGui() instanceof ConfirmBackupScreen) {
                ConfirmBackupScreen gui2 = (ConfirmBackupScreen)event.getGui();
                if (SGClientEvents.doesTitleMatch(gui2.func_231171_q_(), "selectWorld.backupQuestion.experimental") && SGClientEvents.hasButton(gui2.field_230710_m_, 1)) {
                    StructureGelMod.LOGGER.info("Skipped backup request screen for world that uses experimental settings. You can disable this via config.");
                    ((AbstractButton)gui2.field_230710_m_.get(1)).func_230930_b_();
                }
            } else if (event.getGui() instanceof ConfirmScreen && SGClientEvents.doesTitleMatch((gui = (ConfirmScreen)event.getGui()).func_231171_q_(), "selectWorld.backupQuestion.experimental") && SGClientEvents.hasButton(gui.field_230710_m_, 0)) {
                StructureGelMod.LOGGER.info("Skipped world load warning screen for world that uses experimental settings. You can disable this via config.");
                ((AbstractButton)gui.field_230710_m_.get(0)).func_230930_b_();
            }
        }
    }

    private static boolean hasButton(List<Widget> buttons, int index) {
        return buttons.size() > index && buttons.get(index) instanceof AbstractButton;
    }

    private static boolean doesTitleMatch(ITextComponent title, String compare) {
        return title instanceof TranslationTextComponent && ((TranslationTextComponent)title).func_150268_i().equals(compare);
    }

    protected static void onPlaySound(PlaySoundEvent event) {
        ResourceLocation name = event.getSound().func_147650_b();
        GelPortalBlock portal = GelEntity.getPortalClient();
        if (portal != null) {
            if (name.equals((Object)SoundEvents.field_187812_eh.func_187503_a())) {
                event.setResultSound(portal.getTravelSound());
            } else if (name.equals((Object)SoundEvents.field_187814_ei.func_187503_a())) {
                event.setResultSound(portal.getTriggerSound());
            }
        }
    }
}

